% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{TernaryMeshVertices}
\alias{TernaryMeshVertices}
\title{Vertex Coordinates of Sub-Triangles in Segmented Equilateral Triangle}
\usage{
TernaryMeshVertices(C)
}
\arguments{
\item{C}{n by 4 matrix of barycentric centroid coordinates of n=k^2
sub-triangles. Column order: id, p1, p2, p3 with id=1,...,k^2.}

\item{k}{Number of rows in the segmented equilateral triangle.}
}
\value{
A numeric matrix with index, vertex id and barycentric vertex
  coordinates for each of the k^2 sub-triangles.
}
\description{
Given the barycentric centroid coordinates of the sub-triangles in an
equilateral triangle subdivided into k^2 equilateral sub-triangles, return
the barycentric vertex coordinates of each sub-triangle.
}
\examples{
k = 2
C <- tricolore:::TernaryMeshCentroids(k)
tricolore:::TernaryMeshVertices(C)

}
\references{
S. H. Derakhshan and C. V. Deutsch (2009): A Color Scale for Ternary Mixtures.
}
\keyword{internal}
