% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{TernarySurroundingSextant}
\alias{TernarySurroundingSextant}
\title{Return Surrounding Sextant of Barycentric Coordinates}
\usage{
TernarySurroundingSextant(P, center)
}
\arguments{
\item{P}{n by 3 matrix of ternary coordinates {p1, p2, p3}_i for
i=1,...,n.}

\item{center}{The sextant center.
A vector of ternary coordinates {p1, p2, p3}.}
}
\value{
An n element character vector of sextant id's 1 to 6.
}
\description{
Given barycentric coordinates return the id of the surrounding sextant.
}
\examples{
P <- prop.table(matrix(runif(9), ncol = 3), 1)
tricolore:::TernarySurroundingSextant(P, rep(1/3, 3))

}
\keyword{internal}
