% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_duplicated_log_entry.R
\name{is.duplicated.log.entry}
\alias{is.duplicated.log.entry}
\title{Check if a new log entry would be a duplicate of on an already existing log entry}
\usage{
is.duplicated.log.entry(log.entry)
}
\arguments{
\item{log.entry}{A \code{data.frame} with the new log entry (exactly one row)}
}
\value{
\code{TRUE} if the \code{log.entry} is a duplicate, else \code{FALSE}
}
\description{
The \code{log.entry} is checked against the existing log entries from
\code{\link{last.tryCatchLog.result}} using the following columns:
        \enumerate{
        \item{msg.text}
        \item{full.stack.trace}
        }
}
\note{
Required function to fix issue # 18
       (\url{https://github.com/aryoda/tryCatchLog/issues/18})
}
\seealso{
\code{\link{last.tryCatchLog.result}},
         \code{\link{build.log.entry}}
}
