% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_vtscopula.R
\name{profilefulcrum}
\alias{profilefulcrum}
\title{Profile likelihood for fulcrum parameter}
\usage{
profilefulcrum(
  data,
  tscopula = dvinecopula(family = 1, pars = list(0.1)),
  locations = seq(0, 1, by = 0.1),
  plot = TRUE
)
}
\arguments{
\item{data}{a vector or time series of data on (0,1).}

\item{tscopula}{an object of class \linkS4class{tscopulaU} or \linkS4class{vtscopula}.}

\item{locations}{vector containing locations of different values for fulcrum.}

\item{plot}{logical values specifying whether plot should be created.}
}
\value{
A matrix containing fulcrum values and log likelihood values.
}
\description{
Profile likelihood for fulcrum parameter
}
\examples{
copobject <- armacopula(pars = list(ar = 0.6, ma = 0.2))
vtcop <- vtscopula(copobject, Vtransform = V2p())
y <- sim(vtcop)
profilefulcrum(y, vtcop)
}
