test_that("garch(1,1) backtest:rolling",{
    spec <- garch_modelspec(y[1:1800,1], constant = TRUE, model = "garch", order = c(1,1), vreg = y[1:1800,2], distribution = "norm")
    b <- tsbacktest(spec, start = 1000, end = 1200, h = 1, estimate_every = 100, rolling = TRUE, trace = FALSE)
    f_dates_diff <- unique(diff(b$table$forecast_date))
    e_dates_diff <- as.integer(max(diff(b$table$estimation_date)))
    e_dates_diff <- as.integer(max(diff(b$table$estimation_date)))
    e_dates_sum <- as.integer(sum(diff(b$table$estimation_date)))
    expect_equal(f_dates_diff, 1)
    expect_equal(e_dates_diff, 100)
    expect_equal(e_dates_sum, 200 - 100)
    expect_equal(NROW(b$table), 200)
})

test_that("garch(1,1) backtest:rolling multihorizon",{
    spec <- garch_modelspec(y[1:1800,1], constant = TRUE, model = "garch", order = c(1,1), vreg = y[1:1800,2], distribution = "norm")
    b <- tsbacktest(spec, start = 1000, end = 1200, h = 5, estimate_every = 100, rolling = TRUE, trace = FALSE)
    f_dates_diff <- unique(b$table$forecast_date - b$table$filter_date)
    e_dates_diff <- as.integer(max(diff(b$table$estimation_date)))
    e_dates_diff <- as.integer(max(diff(b$table$estimation_date)))
    e_dates_sum <- as.integer(sum(diff(b$table$estimation_date)))
    expect_equal(max(f_dates_diff), 5)
    expect_equal(min(f_dates_diff), 1)
    expect_equal(e_dates_diff, 100)
    expect_equal(e_dates_sum, 200 - 100)
    expect_equal(NROW(b$table), 5 * 200 - 5*2)
})

test_that("garch(1,1) backtest: non rolling",{
    spec <- garch_modelspec(y[1:1800,1], constant = TRUE, model = "garch", order = c(1,1), vreg = y[1:1800,2], distribution = "norm")
    b <- tsbacktest(spec, start = 1000, end = 1200, h = 100, estimate_every = 100, rolling = FALSE, trace = FALSE)
    f_dates_diff <- unique(diff(b$table$forecast_date))
    e_dates_diff <- as.integer(max(diff(b$table$estimation_date)))
    e_dates_diff <- as.integer(max(diff(b$table$estimation_date)))
    e_dates_sum <- as.integer(sum(diff(b$table$estimation_date)))
    expect_equal(max(f_dates_diff), 1)
    expect_equal(min(f_dates_diff), 1)
    expect_equal(e_dates_diff, 100)
    expect_equal(e_dates_sum, 200 - 100)
    expect_equal(NROW(b$table), 200)
})


test_that("garch(1,1) backtest: non rolling non overlapping",{
    spec <- garch_modelspec(y[1:1800,1], constant = TRUE, model = "garch", order = c(1,1), vreg = y[1:1800,2], distribution = "norm")
    b <- tsbacktest(spec, start = 1000, end = 1200, h = 80, estimate_every = 100, rolling = FALSE, trace = FALSE)
    f_dates_diff <- unique(diff(b$table$forecast_date))
    e_dates_diff <- as.integer(max(diff(b$table$estimation_date)))
    e_dates_diff <- as.integer(max(diff(b$table$estimation_date)))
    e_dates_sum <- as.integer(sum(diff(b$table$estimation_date)))
    expect_equal(max(f_dates_diff), 21)
    expect_equal(min(f_dates_diff), 1)
    expect_equal(e_dates_diff, 100)
    expect_equal(e_dates_sum, 200 - 100)
    expect_equal(NROW(b$table), 200 - 40)
})
