% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill-na.R
\name{count_gaps}
\alias{count_gaps}
\alias{count_gaps.tbl_ts}
\alias{count_gaps.grouped_ts}
\alias{gaps}
\title{Count implicit gaps}
\usage{
count_gaps(.data, ...)

\method{count_gaps}{tbl_ts}(.data, ...)

\method{count_gaps}{grouped_ts}(.data, .full = FALSE, ...)

gaps(x, y)
}
\arguments{
\item{.data}{A \code{tbl_ts}.}

\item{...}{Other arguments passed on to individual methods.}

\item{.full}{\code{FALSE} to find gaps for each group within its own period. \code{TRUE}
to find gaps over the entire time span of the data.}

\item{x, y}{Atomic vectors. The length of \code{y} must be greater than the length of \code{x}.}
}
\value{
A tibble contains:
\itemize{
\item the "key" of the \code{tbl_ts}
\item "from": the starting time point of the gap
\item "end": the ending time point of the gap
\item "n": the implicit missing observations during the time period
}
}
\description{
\code{count_gaps()} counts gaps for a tsibble; \code{gaps()} find where the gaps in \code{x}
with respect to \code{y}.
}
\examples{
# Implicit missing time without group_by ----
# All the sensors have 2 common missing time points in the data
count_gaps(pedestrian)
# Time gaps for each sensor per month ----
pedestrian \%>\% 
  index_by(yrmth = yearmonth(Date)) \%>\% 
  group_by(Sensor) \%>\% 
  count_gaps()
# Time gaps for each sensor ----
ped_gaps <- pedestrian \%>\% 
  group_by(Sensor) \%>\% 
  count_gaps(.full = TRUE)
if (!requireNamespace("ggplot2", quietly = TRUE)) {
  stop("Please install the ggplot2 package to run these following examples.")
}
library(ggplot2)
ggplot(ped_gaps, aes(colour = Sensor)) +
  geom_linerange(aes(x = Sensor, ymin = from, ymax = to)) +
  geom_point(aes(x = Sensor, y = from)) +
  geom_point(aes(x = Sensor, y = to)) +
  coord_flip() +
  theme(legend.position = "bottom")
# Vectors ----
gaps(x = c(1:3, 5:6, 9:10), y = 1:10)
}
\seealso{
\link{fill_na}
}
