% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_compare_gvar.R
\name{plot.compare_gvar}
\alias{plot.compare_gvar}
\title{Plot compare_gvar}
\usage{
\method{plot}{compare_gvar}(x, name_a = NULL, name_b = NULL, ...)
}
\arguments{
\item{x}{An object of class "compare_gvar".}

\item{name_a}{Optional. The name for model A. If provided, it replaces
"mod_a" in the plot.}

\item{name_b}{Optional. The name for model B. If provided, it replaces
"mod_b" in the plot.}

\item{...}{Additional arguments to be passed to the plotting functions.}
}
\value{
A ggplot object representing the density plots of the posterior
uncertainty distributions for distances and the empirical distance for two GVAR models.
}
\description{
This function is a plotting method for the class produced by
[compare_gvar()]. It generates a plot showing the density of posterior
uncertainty distributions for distances and the empirical distance value for two GVAR models.
}
\details{
The function first checks if the full reference distributions of
[compare_gvar()] are saved using the argument 'return_all' set to TRUE. If
not, an error is thrown.

Using the "name_a" and "name_b" arguments allows for custom labeling of the
two models in the plot.

The function generates two density plots using `ggplot2`, one for the
temporal network (beta) and another for the contemporaneous network (pcor).
The density distributions are filled with different colors based on the
corresponding models (mod_a and mod_b). The empirical distances between the
networks are indicated by red vertical lines.
}
\examples{
\donttest{
data(fit_data)
test_res <- compare_gvar(fit_data[[1]],
fit_data[[2]],
n_draws = 100,
return_all = TRUE)
plot(test_res)
}
}
