% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_an.R
\name{ts_norm_an}
\alias{ts_norm_an}
\title{Time Series Adaptive Normalization}
\usage{
ts_norm_an(outliers = outliers_boxplot(), nw = 0)
}
\arguments{
\item{outliers}{Indicate outliers transformation class. NULL can avoid outliers removal.}

\item{nw}{integer: window size.}
}
\value{
returns a \code{ts_norm_an} object.
}
\description{
Transform data to a common scale while taking into account the
changes in the statistical properties of the data over time.
}
\examples{
# time series to normalize
library(daltoolbox)
data(sin_data)

# convert to sliding windows
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# normalization
preproc <- ts_norm_an()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
