% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv2f.R
\name{cv2f}
\alias{cv2f}
\title{Compute a frequency-specific version of CVcom or CVcomip}
\usage{
cv2f(X, type)
}
\arguments{
\item{X}{A matrix with counts or densities arranged in species by time step}

\item{type}{If \code{com}, calculate a frequency-specific CVcom2. If \code{comip}, calculate a 
frequency-specific CVcomip2. See the vignette for definitions of these quantities.}
}
\value{
\code{cv2f} returns an object of type list consisting of
\item{frequency}{a vector from 0 to 1 (not including 0 and 1)}
\item{cv2}{A vector of frequency-specific population or community variability}
}
\description{
Compute a frequency-specific version of CVcom or CVcomip.
}
\examples{
X<-matrix(runif(200,1,100), 10, 20) 
ans<-cv2f(X, type="com")

}
\references{
Zhao et al, (In prep) Decomposition of the variance ratio illuminates timescale-specific
population and community variability.
}
\seealso{
\code{\link{tsvreq_classic}}, \code{\link{cv2}}, \code{browseVignettes("tsvr")}
}
\author{
Shaopeng Wang, \email{shaopeng.wang@pku.edu.cn}; Lei Zhao, \email{lei.zhao@cau.edu.cn}; Daniel Reuman, \email{reuman@ku.edu}
}
