% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectations_xl.R
\name{ttdo_boolean_and_message_tests}
\alias{ttdo_boolean_and_message_tests}
\alias{expect_true_xl}
\alias{expect_false_xl}
\alias{expect_null_xl}
\alias{expect_silent_xl}
\alias{expect_error_xl}
\alias{expect_warning_xl}
\alias{expect_message_xl}
\title{Extensions of boolean and messaging tests from tinytest}
\usage{
expect_true_xl(current, info = NA_character_, ...)

expect_false_xl(current, info = NA_character_, ...)

expect_null_xl(current, info = NA_character_, ...)

expect_silent_xl(current, quiet = TRUE, info = NA_character_, ...)

expect_error_xl(current, pattern = ".*", info = NA_character_, ...)

expect_warning_xl(current, pattern = ".*", info = NA_character_, ...)

expect_message_xl(current, pattern = ".*", info = NA_character_, ...)
}
\arguments{
\item{current}{\code{[R object or expression]} Outcome or expression under scrutiny.}

\item{info}{scalar. Optional user-defined message. Must be a single character string. 
Multiline comments may be separated by "\\n".}

\item{...}{Passed to \code{all.equal} and returned as a test attribute}

\item{quiet}{\code{[logical]} suppress output printed by the current expression (see examples)}

\item{pattern}{\code{[character]} A regular expression to match the message.}
}
\value{
A \code{\link{tinytest}} object. A tinytest object is a
\code{logical} with attributes holding information about the
test that was run
}
\description{
Building on the tinytest functions for testing boolean values with additional test 
feedback through attributes.
}
\details{
While tinytest does now support the passing of additional information with the info
field in its tests, they are not yet supported in the \code{as.data.frame.tinytests}
method.
}
\examples{
library(tinytest)
using(ttdo)
expect_true_xl(TRUE, score = 3) # TRUE
expect_true_xl(FALSE, name = "check 1-1==2", score = 1, totalpts = 2) # FALSE

}
