% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvReg-package.R
\docType{package}
\name{tvReg-package}
\alias{tvReg-package}
\alias{tvReg}
\title{tvReg: Time-Varying Coefficient for Single and Multi-Equation Regressions}
\description{
This package covers a large range of semiparametric regression methods with 
time-varying coefficients using nonparametric kernel smoothing for the estimation.
}
\section{Main functions}{

The five basic functions in this package are \code{\link{tvLM}}, \code{\link{tvAR}}, 
\code{\link{tvSURE}}, \code{\link{tvPLM}}, \code{\link{tvVAR}} and \code{\link{tvIRF}}. 
Moreover, this package provides the \code{\link{confint}}, \code{\link{fitted}}, 
\code{\link{forecast}}, \code{\link{plot}}, \code{\link{predict}}, \code{\link{print}}, 
\code{\link{resid}} and \code{\link{summary}} methods adapted to the class attributes 
of the \code{tvReg}. 
In addition, it includes bandwidth selection methods, time-varying variance-covariance 
estimators and four estimation procedures: the time-varying ordinary least squares, 
which are implemented in the \code{\link{tvOLS}} methods, the time-varying 
generalised least squares for a list of equations, which is implemented in the 
\code{\link{tvGLS}} methods, time-varying pooled and random effects estimators for 
panel data, which are implemented in the \code{\link{tvRE}} and the time-varying 
fixed effects estimator, which is implemente in the \code{\link{tvFE}}.
}

\section{Further information}{

Details on the theory and applications to finance and macroeconomics can be found 
in Casas and Fernandez-Casal (2019, \url{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3363526}),
and in the package vignette \url{https://icasas.github.io/tvReg/articles/tvReg.html}.
}

\section{Acknowledgments}{
 
Funded by the Horizon 2020. Framework Programme of the European Union.
}

\references{
Casas, I. and Fernandez-Casal, R., \emph{tvReg: Time-varying Coefficient Linear 
Regression for Single and Multi-Equations in R} (April 1, 2019). 
Available at SSRN: \url{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3363526}.
}
\author{
Isabel Casas (\email{casasis@gmail.com}),
Ruben Fernandez-Casal (\email{rubenfcasal@gmail.com}).
}
