% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipper.R
\name{clipper}
\alias{clipper}
\title{Clipper}
\usage{
clipper(tarjet, centre = c(128, 128), rad = 120, slice = 1)
}
\arguments{
\item{tarjet}{object of class \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}} (or matrix) to clip.}

\item{centre}{The coordinates of the polygon centre (x,y).}

\item{rad}{The circle radius.}

\item{slice}{which slice of the \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}} object should be clipped? (only one!)}
}
\value{
The tarjet object clipped as matrix (and S3 clipper -not for human consumption).
}
\description{
A function to clip a \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}} object object (also a matrix, but I recommed this only for debugging). ALthough you can use this function in a 'step by step' process it is otherwise directly called by \code{\link{summary_sam}} which uses a \code{\link[=clipmask-class]{clipmask}} object (returned by \code{\link{toClip}} as a clipping mask.
}
\examples{
x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
x <- tile_base_corr(x)
x <- wavealign(x, primpke)
x <- tile_sam(x)
x <- smooth_sam(x, as.integer(length(primpke@clusternames)), window = 3, 1)

clip <- toClip(8,20,c(10,10))
plot(x)
polygon(clip@xycoords)

x <- clipper(x, clip@centre, clip@rad, 1)

}
\seealso{
\code{\link{toClip}} code{\link[=clipmask-class]{clipmask}} \code{\link{summary_sam}}.
}
