% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneticAlgorithm.R
\name{random_regime}
\alias{random_regime}
\title{Create random regime parameters}
\usage{
random_regime(
  p,
  mu_scale,
  sigma_scale,
  restricted = FALSE,
  constraints = NULL,
  m,
  forcestat = FALSE
)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{mu_scale}{a real valued vector of length two specifying the mean (the first element) and standard deviation (the second element)
of the normal distribution from which the \eqn{\mu_{m}} mean-parameters are generated in random mutations in the genetic algorithm.
Default is \code{c(mean(data), sd(data))}.
Note that the genetic algorithm optimizes with mean-parametrization even when \code{parametrization=="intercept"}, but
input (in \code{initpop}) and output (return value) parameter vectors may be intercept-parametrized.}

\item{sigma_scale}{a positive real number specifying the standard deviation of the (zero mean, positive only by taking absolute value)
normal distribution from which the component variance parameters are generated in the random mutations in the genetic algorithm.
Default is \code{var(stats::ar(data, order.max=10)$resid, na.rm=TRUE)}.}

\item{restricted}{a logical argument stating whether the AR coefficients \eqn{\phi_{m,1},...,\phi_{m,p}} are restricted
to be the same for all regimes.}

\item{constraints}{specifies linear constraints imposed to each regime's autoregressive parameters separately.
\describe{
\item{For \strong{non-restricted} models:}{a list of size \eqn{(pxq_{m})} constraint matrices \strong{\eqn{C_{m}}} of full column rank
  satisfying \strong{\eqn{\phi_{m}}}\eqn{=}\strong{\eqn{C_{m}\psi_{m}}} for all \eqn{m=1,...,M}, where
  \strong{\eqn{\phi_{m}}}\eqn{=(\phi_{m,1},...,\phi_{m,p})} and \strong{\eqn{\psi_{m}}}\eqn{=(\psi_{m,1},...,\psi_{m,q_{m}})}.}
\item{For \strong{restricted} models:}{a size \eqn{(pxq)} constraint matrix \strong{\eqn{C}} of full column rank satisfying
  \strong{\eqn{\phi}}\eqn{=}\strong{\eqn{C\psi}}, where \strong{\eqn{\phi}}\eqn{=(\phi_{1},...,\phi_{p})} and
  \strong{\eqn{\psi}}\eqn{=\psi_{1},...,\psi_{q}}.}
}
The symbol \eqn{\phi} denotes an AR coefficient. Note that regardless of any constraints, the autoregressive order
is always \code{p} for all regimes.
Ignore or set to \code{NULL} if applying linear constraints is not desired.}

\item{m}{which regime? This is required for models with constraints for which a list of possibly differing
constraint matrices is provided.}

\item{forcestat}{use the algorithm by Monahan (1984) to force stationarity on the AR parameters (slower)?
Not supported for constrained models.}
}
\value{
\describe{
  \item{Regular models:}{\strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m}^2)}
  where \strong{\eqn{\phi_{m}}}=\eqn{(\phi_{m,1},...,\phi_{m,p})}.}
  \item{Restricted models:}{Not supported!}
  \item{Constrained models:}{Replace the vectors \strong{\eqn{\phi_{m}}} with vectors \strong{\eqn{\psi_{m}}}.}
}
}
\description{
\code{random_regime} generates random regime parameters.
}
\details{
If \code{forcestat==TRUE}, then the AR coefficients are relatively large, otherwise they are usually relatively small.
}
\references{
\itemize{
   \item Monahan J.F. 1984. A Note on Enforcing Stationarity in Autoregressive-Moving Average Models.
         \emph{Biometrica} \strong{71}, 403-404.
 }
}
