% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldAndLR.R, R/printMethods.R
\name{Wald_test}
\alias{Wald_test}
\alias{print.wald}
\title{Perform Wald test}
\usage{
Wald_test(gsmar, A, c, h = 6e-06)

\method{print}{wald}(x, ..., digits = 4)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{A}{a size \eqn{(k x n_params)} matrix with full row rank specifying part of the null hypothesis
where \eqn{n_params} is the number of parameters in the (unconstrained) model.
See details for more information.}

\item{c}{a length \eqn{k} vector specifying part of the null hypothesis. See details for more information.}

\item{h}{the difference used to approximate the derivatives.}

\item{x}{object of class \code{'wald'} generated by the function \code{Wald_test}.}

\item{...}{other arguments passed to \code{fn}.}

\item{digits}{how many significant digits to print?}
}
\value{
Returns an object of class \eqn{'wald'} containing the test statistic and the related p-value.
}
\description{
\code{Wald_test} performs a Wald test for a GMAR, StMAR, or G-StMAR model.
}
\details{
Denoting the true parameter value by \eqn{\theta_{0}}, we test the null hypothesis \eqn{A\theta_{0}=c}.
  Under the null, the test statistic is asymptotically \eqn{\chi^2}-distributed with \eqn{k}
  (\code{=nrow(A)}) degrees of freedom. The parameter \eqn{\theta_{0}} is assumed to have the same form as in
  the model supplied in the argument \code{gsmar} and it is presented in the documentation of the argument
  \code{params} in the function \code{GSMAR} (see \code{?GSMAR}).

  Finally, note that this function does \strong{not} check whether the specified constraints are feasible (e.g. whether
  the implied constrained model would be stationary or have positive definite error term covariance matrices).
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: print method
}}

\examples{
\donttest{
# GMAR p=1, M=2 model:
fit12 <- fitGSMAR(simudata, p=1, M=2, model="GMAR", ncalls=1, seeds=1)

# Test with Wald test whether the AR coefficients are the same in both
# regimes:
# There are 7 parameters in the model and the AR coefficient of the
# first regime is the 2nd element, whereas the AR coefficient of the second
# regime is in the 5th element.
A <- matrix(c(0, 1, 0, 0, -1, 0, 0), nrow=1, ncol=7)
c <- 0
Wald_test(fit12, A=A, c=c)
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2021. A mixture autoregressive model based on Student's t-distribution.
           \emph{Communications in Statistics - Theory and Methods}, doi: 10.1080/03610926.2021.1916531
   \item Virolainen S. forthcoming. A mixture autoregressive model based on Gaussian and Student's t-distributions.
           Studies in Nonlinear Dynamics & Econometrics, (preprint available as arXiv:2003.05221).
 }
}
\seealso{
\code{\link{LR_test}}, \code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{diagnostic_plot}},
 \code{\link{profile_logliks}}, \code{\link{quantile_residual_tests}}, \code{\link{cond_moment_plot}}
}
