% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecatedFunctions.R
\name{simulateGSMAR}
\alias{simulateGSMAR}
\title{DEPRECATED, USE \code{simulate.gsmar} INSTEAD! Simulate observations from GMAR, StMAR, and G-StMAR processes}
\usage{
simulateGSMAR(
  object,
  nsim,
  init_values = NULL,
  ntimes = 1,
  drop = TRUE,
  gsmar = NULL,
  nsimu = NULL
)
}
\arguments{
\item{object}{object of class \code{'gsmar'}, typically created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{nsim}{a positive integer specifying how many values (ahead from \code{init_values}) will be simulated.}

\item{init_values}{a numeric vector with length \code{>=p} specifying the initial values for the simulation. The \strong{last}
element will be used as the initial value for the first lag, the second last element will be initial value for the second lag, etc.
If \code{NULL}, initial values will be simulated from the process's stationary distribution.}

\item{ntimes}{a positive integer specifying how many sets of simulations should be performed.}

\item{drop}{if \code{TRUE} (default) then the components of the returned list are coerced to lower dimension if \code{ntimes==1},
i.e., \code{$sample} and \code{$component} will be vectors and \code{$mixing_weights} will be matrix.}

\item{gsmar}{a class 'gsmar' object, typically generated by \code{fitGSMAR} or \code{GSMAR}.}

\item{nsimu}{a positive integer specifying how many values (ahead from \code{init_values}) will be simulated.}
}
\value{
If \code{drop==TRUE} and \code{ntimes==1} (default): \code{$sample} and \code{$component} are vectors
 and \code{$mixing_weights} is a (\code{nsim}\eqn{xM}) matrix. Otherwise, returns a list with...
  \describe{
    \item{\code{$sample}}{a size (\code{nsim}\eqn{x}\code{ntimes}) matrix containing the simulated values.}
    \item{\code{$component}}{a size (\code{nsim}\eqn{x}\code{ntimes}) matrix containing the information from which
     mixture component each value was generated from.}
    \item{\code{$mixing_weights}}{a size (\code{nsim}\eqn{xMx}\code{ntimes}) array containing the mixing weights corresponding to the
     sample: the dimension \code{[i, , ]} is the time index, the dimension \code{[, i, ]} indicates the regime, and the dimension
     \code{[, , i]} indicates the i:th set of simulations.}
  }
}
\description{
\code{simulateGSMAR} simulates observations from the specified GMAR, StMAR, or G-StMAR process.
 Can be utilized for forecasting future values of the process. DEPRECATED, USE \code{simulate.gsmar} INSTEAD!
}
\details{
DEPRECATED, USE \code{simulate.gsmar} INSTEAD!

 The argument \code{ntimes} is intended for forecasting: a GSMAR process can be forecasted by simulating its
 possible future values. One can perform a large number of sets of simulations and calculate the sample quantiles from
 the simulated values to obtain prediction intervals. See the forecasting example below for a hand-on demonstration.
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2021. A mixture autoregressive model based on Student's t-distribution.
           \emph{Communications in Statistics - Theory and Methods}, doi: 10.1080/03610926.2021.1916531
   \item Virolainen S. 2021. A mixture autoregressive model based on Gaussian and Student's t-distributions.
         Studies in Nonlinear Dynamics & Econometrics,doi: 10.1515/snde-2020-0060
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{predict.gsmar}},
 \code{\link{add_data}}, \code{\link{cond_moments}}, \code{\link{mixing_weights}}
}
