% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/karim.R
\name{read_gpx}
\alias{read_gpx}
\title{Read GPX file}
\usage{
read_gpx(
  file,
  layers = c("waypoints", "tracks", "routes", "track_points", "route_points")
)
}
\arguments{
\item{file}{a GPX filename (including directory)}

\item{layers}{vector of GPX layers. Possible options are \code{"waypoints"}, \code{"tracks"}, \code{"routes"}, \code{"track_points"}, \code{"route_points"}. By dedault, all those layers are read.}
}
\value{
if the layer has any features a sp object is returned.
}
\description{
Read a GPX file. By default, it reads all possible GPX layers, and only returns shapes for layers that have any features.
}
\note{
cloned from tmap
}
\examples{
\dontrun{
## for visualisation we are using mapview
## assign  GPX file
gpxFN <- system.file("extdata", "flighttrack.gpx", package = "uavRmp")

## read it
gpx <- read_gpx(gpxFN, layers=c("tracks"))

## plot it
plot(gpx$geometry)

}
}
