% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_report_ph_content}
\alias{system_report_ph_content}
\title{Populate Placeholder In Officer Report}
\usage{
system_report_ph_content(cfg, rpt, content_type, content, type, index,
  ph_label)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{rpt}{officer pptx object}

\item{content_type}{string indicating the content type}

\item{content}{content}

\item{type}{placeholder type (\code{"body"})}

\item{index}{placeholder index (integer)}

\item{ph_label}{placeholder location (text)}
}
\value{
officer pptx object with the content added
}
\description{
Places content in a PowerPoint placeholder for a given Officer document.
}
\details{
For each content type listed below the following content is expected:

\itemize{
 \item \code{"text"} text string of information
 \item \code{"list"} vector of paired values (indent level and text), eg.  c(1, "Main Bullet", 2 "Sub Bullet")
 \item \code{"imagefile"} string containing path to image file
 \item \code{"ggplot"} ggplot object, eg. p = ggplot() + ....
 \item \code{"table"} list containing the table content and other options with the following elements (defaults in parenthesis):
  \itemize{
     \item \code{table} Data frame containing the tabular data
     \item \code{header} Boolean variable to control displaying the header (\code{TRUE})
     \item \code{first_row} Boolean variable to indicate that the first row contains header information (\code{TRUE})
   }
 \item \code{"flextable"} list containing flextable content and other options with the following elements (defaults in parenthesis):
  \itemize{
     \item \code{table} Data frame containing the tabular data
     \item \code{header_top}, \code{header_middle}, \code{header_bottom} (\code{NULL}) a list with the same names as the data frame names containing the tabular data and values with the header text to show in the table
     \item \code{merge_header} (\code{TRUE}) Set to true to combine column headers with the same information
     \item \code{table_body_alignment}, table_header_alignment ("center") Controls alignment
     \item \code{table_autofit} (\code{TRUE}) Automatically fit content, or specify the cell width and height with \code{cwidth} (\code{0.75}) and \code{cheight} (\code{0.25})
     \item \code{table_theme} (\code{"theme_vanilla"}) Table theme
   }
 }
}
\seealso{
\code{\link{system_report_view_layout}}
}
