% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_report_slide_two_col}
\alias{system_report_slide_two_col}
\title{Generate Slide with Two Column Layout}
\usage{
system_report_slide_two_col(
  cfg,
  title = "Title",
  sub_title = NULL,
  rptname = "default",
  content_type = "text",
  left_content = NULL,
  left_content_type = NULL,
  right_content = NULL,
  right_content_type = NULL,
  left_content_header = NULL,
  left_content_header_type = "text",
  right_content_header = NULL,
  right_content_header_type = "text"
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{title}{string with slide title (\code{"Title"})}

\item{sub_title}{string with slide sub title (code{NULL})}

\item{rptname}{report name initialized with \code{system_report_init}}

\item{content_type}{type of content for body text elements 'list' or 'text'}

\item{left_content}{content of left column}

\item{left_content_type}{inherits the main 'content_type' above unless you wish to specify an image or table}

\item{right_content}{content of right column}

\item{right_content_type}{inherits the main 'content_type' above unless you wish to specify an image or table}

\item{left_content_header}{content of left column header}

\item{left_content_header_type}{'text' unless you wish to specify an image or table}

\item{right_content_header}{content of right column header}

\item{right_content_header_type}{'text' unless you wish to specify an image or table}
}
\value{
ubiquity system object with slide added to report
}
\description{
Creates a report slide with a title two columns of content with optional headers over the columns
}
\details{
For information on the format of content, see \code{\link{system_report_ph_content}}.
}
\seealso{
\code{\link{system_report_init}} and the reporting vignette (\code{vignette("Reporting", package = "ubiquity")})
}
