% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_rpt_read_template}
\alias{system_rpt_read_template}
\title{Initialize a New Officer Report}
\usage{
system_rpt_read_template(
  cfg,
  template = "PowerPoint",
  mapping = NULL,
  rptname = "default"
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{template}{Type of template to use or path to template file.}

\item{mapping}{Path to an onbrand yaml mapping file: If an internal ubiquity
template has been supplied, this argument will be ignored and the yaml file
from ubiquity will be used.}

\item{rptname}{report name}
}
\value{
ubiquity system object with and empty report initialized
}
\description{
Creates a new officer report based either on the ubiquity
template or one specified by the user. Once created, content can then be
added.
}
\details{
The `template` and `mapping` inputs can specify either the internal
  ubiquity templates or user-defined templates  If you specify `template`
  values of 'PowerPoint` or `Word` then the internal
  ubiquity templates for PowerPoint or Word will be used and the mapping
  information will be ignored.

  If templates other than the values above are specified you will need also
  supply a yaml mapping file for an `onbrand` reporting template. The
  vignette below highlights how to go about creating these files.
}
\seealso{
Reporting vignette (\code{vignette("Reporting", package = "ubiquity")})

Custom Office Template vignette (\code{vignette("Custom_Office_Templates", package="onbrand")})
}
