% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omegaSqDist.R
\name{pomegaSq}
\alias{pomegaSq}
\alias{domegaSq}
\alias{qomegaSq}
\alias{romegaSq}
\title{The distribution of Omega Squared}
\usage{
pomegaSq(q, df1, df2, populationOmegaSq = 0, lower.tail = TRUE)

qomegaSq(p, df1, df2, populationOmegaSq = 0, lower.tail = TRUE)

romegaSq(n, df1, df2, populationOmegaSq = 0)

domegaSq(x, df1, df2, populationOmegaSq = 0)
}
\arguments{
\item{df1, df2}{Degrees of freedom for the numerator and the denominator,
respectively.}

\item{populationOmegaSq}{The value of Omega Squared in the population; this
determines the center of the Omega Squared distribution. This has not been
implemented yet in this version of \code{userfriendlyscience}. If anybody
has the inverse of \code{\link[=convert.ncf.to.omegasq]{convert.ncf.to.omegasq()}} for me, I'll happily
integrate this.}

\item{lower.tail}{logical; if TRUE (default), probabilities are the
likelihood of finding an Omega Squared smaller than the specified value;
otherwise, the likelihood of finding an Omega Squared larger than the
specified value.}

\item{p}{Vector of probabilites (\emph{p}-values).}

\item{n}{Desired number of Omega Squared values.}

\item{x, q}{Vector of quantiles, or, in other words, the value(s) of Omega
Squared.}
}
\value{
\code{domegaSq} gives the density, \code{pomegaSq} gives the
distribution function, \code{qomegaSq} gives the quantile function, and
\code{romegaSq} generates random deviates.
}
\description{
These functions use some conversion to and from the \emph{F} distribution to
provide the Omega Squared distribution.
}
\details{
The functions use \code{\link[=convert.omegasq.to.f]{convert.omegasq.to.f()}} and
\code{\link[=convert.f.to.omegasq]{convert.f.to.omegasq()}} to provide the Omega Squared
distribution.
}
\examples{

### Generate 10 random Omega Squared values
romegaSq(10, 66, 3);

### Probability of findings an Omega Squared
### value smaller than .06 if it's 0 in the population
pomegaSq(.06, 66, 3);

}
\seealso{
\code{\link[=convert.omegasq.to.f]{convert.omegasq.to.f()}},
\code{\link[=convert.f.to.omegasq]{convert.f.to.omegasq()}}, \code{\link[=df]{df()}}, \code{\link[=pf]{pf()}},
\code{\link[=qf]{qf()}}, \code{\link[=rf]{rf()}}
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{univar}
