% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.cer.to.d.R, R/convert.d.to.eer.R,
%   R/convert.d.to.nnc.R, R/convert.eer.to.d.R
\name{convert.cer.to.d}
\alias{convert.cer.to.d}
\alias{convert.d.to.eer}
\alias{convert.d.to.nnc}
\alias{convert.eer.to.d}
\title{Helper functions for Numbers Needed for Change}
\usage{
convert.cer.to.d(cer, eer, eventDesirable = TRUE, eventIfHigher = TRUE)

convert.d.to.eer(d, cer, eventDesirable = TRUE, eventIfHigher = TRUE)

convert.d.to.nnc(d, cer, r = 1, eventDesirable = TRUE,
  eventIfHigher = TRUE)

convert.eer.to.d(eer, cer, eventDesirable = TRUE, eventIfHigher = TRUE)
}
\arguments{
\item{cer}{The Control Event Rate.}

\item{eer}{The Experimental Event Rate.}

\item{eventDesirable}{Whether an event is desirable or undesirable.}

\item{eventIfHigher}{Whether scores above or below the threshold are
considered 'an event'.}

\item{d}{The value of Cohen's \emph{d}.}

\item{r}{The correlation between the determinant and behavior (for mediated
Numbers Needed for Change).}
}
\value{
The converted value.
}
\description{
These functions are used by \code{\link[behaviorchange:nnc]{behaviorchange::nnc()}} to compute the Numbers
Needed for Change, but are also available for manual use.
}
\examples{

convert.d.to.eer(d=.5, cer=.25);
convert.d.to.nnc(d=.5, cer=.25);

}
\references{
Gruijters, S. L., & Peters, G. Y. (2019). Gauging the
impact of behavior change interventions: A tutorial on the Numbers
Needed to Treat. \emph{PsyArXiv.} doi:\href{https://doi.org/10.31234/osf.io/2bau7}{10.31234/osf.io/2bau7}
}
\seealso{
\code{\link[behaviorchange:nnc]{behaviorchange::nnc()}}
}
\author{
Gjalt-Jorn Peters & Stefan Gruijters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{utilities}
