% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\docType{data}
\name{opts}
\alias{opts}
\alias{set}
\alias{get}
\alias{reset}
\title{Options for the ufs package}
\format{
An object of class \code{list} of length 5.
}
\usage{
opts
}
\description{
The \code{ufs::opts} object contains three functions to set, get, and reset
options used by the ufs package. Use \code{ufs::opts$set} to set options,
\code{ufs::opts$get} to get options, or \code{ufs::opts$reset} to reset specific or
all options to their default values.
}
\details{
It is normally not necessary to get or set \code{ufs} options.

The following arguments can be passed:

\describe{
\item{...}{For \code{ufs::opts$set}, the dots can be used to specify the options
to set, in the format \code{option = value}, for example,
\code{tableOutput = c("console", "viewer")}. For
\code{ufs::opts$reset}, a list of options to be reset can be passed.}
\item{option}{For \code{ufs::opts$set}, the name of the option to set.}
\item{default}{For \code{ufs::opts$get}, the default value to return if the
option has not been manually specified.}
}

The following options can be set:

\describe{

\item{tableOutput}{Where to show some tables.}

}
}
\examples{
### Get the default columns in the variable view
ufs::opts$get("tableOutput");

### Set it to a custom version
ufs::opts$set(tableOutput = c("values", "level"));

### Check that it worked
ufs::opts$get("tableOutput");

### Reset this option to its default value
ufs::opts$reset("tableOutput");

### Check that the reset worked, too
ufs::opts$get("tableOutput");

}
\keyword{datasets}
