% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_scale_wide_twin_data}
\alias{umx_scale_wide_twin_data}
\title{umx_scale_wide_twin_data}
\usage{
umx_scale_wide_twin_data(varsToScale, suffix, data)
}
\arguments{
\item{varsToScale}{The base names of the variables ("weight" etc.)}

\item{suffix}{The suffix that distinguishes each case, e.g. "_T")}

\item{data}{a wide dataframe}
}
\value{
- new dataframe with variables scaled in place
}
\description{
Scale wide data across all cases: currently twins
}
\examples{
data(twinData) 
df = umx_scale_wide_twin_data(twinData, varsToScale = c("ht", "wt"), suffix = "" )
plot(wt1 ~ wt2, data = df)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
umx_scale

Other Twin Data functions: \code{\link{umx_long2wide}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_residualize}},
  \code{\link{umx_wide2long}}, \code{\link{umx}}
}
