% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_fit_stash_CIs.R
\name{umx_stash_CIs}
\alias{umx_stash_CIs}
\title{Stash the CI values of a model as strings in the values of the model}
\usage{
umx_stash_CIs(model, digits = 3, dropZeros = FALSE,
  stdAlg2mat = TRUE)
}
\arguments{
\item{model}{An \code{\link{mxModel}} to get CIs from.}

\item{digits}{rounding.}

\item{dropZeros}{makes strings for failed CIs?}

\item{stdAlg2mat}{treat std as algebra: stash in non std matrix.}
}
\value{
- \code{\link{mxModel}}
}
\description{
Stash formatted CIs (e.g. ".1 [-.1, .3]") as strings overwriting the parameter values of the model.
}
\details{
I might change this to a lookup-function that gets a CI string if one exists.
}
\references{
- \url{https://github.com/tbates/umx}
CIname = top.cp_loadings_std[1,1]
thisSub = top; thisMat = cp_loadings_std; thisRow = 1; thisCol = 1
}
\seealso{
- \code{\link{umxConfint}}, \code{\link{xmu_get_CI}}

Other zAdvanced Helpers: \code{\link{umx_merge_CIs}},
  \code{\link{umx_standardize_ACEcov}},
  \code{\link{umx_standardize_ACEv}},
  \code{\link{umx_standardize_ACE}},
  \code{\link{umx_standardize_CP}},
  \code{\link{umx_standardize_IP}},
  \code{\link{umx_standardize_SexLim}},
  \code{\link{umx_standardize_Simplex}}, \code{\link{umx}}
}
\concept{zAdvanced Helpers}
