% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.r
\name{umxCPold}
\alias{umxCPold}
\title{umxCP: Build and run a Common pathway twin model}
\usage{
umxCPold(name = "CPold", selDVs, dzData, mzData, sep = NULL,
  nFac = 1, freeLowerA = FALSE, freeLowerC = FALSE,
  freeLowerE = FALSE, correlatedA = FALSE, equateMeans = TRUE,
  dzAr = 0.5, dzCr = 1, boundDiag = 0, addStd = TRUE,
  addCI = TRUE, numObsDZ = NULL, numObsMZ = NULL,
  autoRun = getOption("umx_auto_run"), optimizer = NULL,
  suffix = "deprecated")
}
\arguments{
\item{name}{The name of the model (defaults to "CP").}

\item{selDVs}{The variables to include.}

\item{dzData}{The DZ dataframe.}

\item{mzData}{The MZ dataframe.}

\item{sep}{The suffix for twin 1 and twin 2, often "_T". If set, selDVs is just the base variable names.
omit suffixes in selDVs, i.e., just "dep" not c("dep_T1", "dep_T2").}

\item{nFac}{How many common factors (default = 1)}

\item{freeLowerA}{Whether to leave the lower triangle of A free (default = FALSE).}

\item{freeLowerC}{Whether to leave the lower triangle of C free (default = FALSE).}

\item{freeLowerE}{Whether to leave the lower triangle of E free (default = FALSE).}

\item{correlatedA}{?? (default = FALSE).}

\item{equateMeans}{Whether to equate the means across twins (defaults to TRUE).}

\item{dzAr}{The DZ genetic correlation (defaults to .5, vary to examine assortative mating).}

\item{dzCr}{The DZ "C" correlation (defaults to 1: set to .25 to make an ADE model).}

\item{boundDiag}{= Numeric lbound for diagonal of the a_cp, c_cp, & e_cp matrices. Set = NULL to ignore.}

\item{addStd}{Whether to add the algebras to compute a std model (defaults to TRUE).}

\item{addCI}{Whether to add the interval requests for CIs (defaults to TRUE).}

\item{numObsDZ}{= not yet implemented: Ordinal Number of DZ twins: Set this if you input covariance data.}

\item{numObsMZ}{= not yet implemented: Ordinal Number of MZ twins: Set this if you input covariance data.}

\item{autoRun}{Whether to mxRun the model (default TRUE: the estimated model will be returned).}

\item{optimizer}{optionally set the optimizer (default NULL does nothing).}

\item{suffix}{DEPRECATED: Use sep instead (see above).}
}
\value{
\itemize{
\item \code{\link{mxModel}}
}
}
\description{
Make a 2-group Common Pathway twin model (Common-factor common-pathway multivariate model).
}
\details{
The common-pathway model provides a powerful tool for theory-based decomposition of genetic
and environmental differences.

umxCP supports this with pairs of mono-zygotic (MZ) and di-zygotic (DZ) twins reared together
to model the genetic and environmental structure of multiple phenotypes
(measured behaviors).

Common-pathway path diagram:

\figure{CP.png}

As can be seen, each phenotype also by default has A, C, and E influences specific to that phenotype.

Like the \code{\link{umxACE}} model, the CP model decomposes phenotypic variance
into Additive genetic, unique environmental (E) and, optionally, either
common or shared-environment (C) or
non-additive genetic effects (D).

Unlike the Cholesky, these factors do not act directly on the phenotype. Instead latent A,
C, and E influences impact on one or more latent factors which in turn account for variance in the phenotypes (see Figure).

\strong{Data Input}
Currently, the umxCP function accepts only raw data. This may change in future versions.

\strong{Ordinal Data}
In an important capability, the model transparently handles ordinal (binary or multi-level
ordered factor data) inputs, and can handle mixtures of continuous, binary, and ordinal
data in any combination.

\strong{Additional features}
The umxCP function supports varying the DZ genetic association (defaulting to .5)
to allow exploring assortative mating effects, as well as varying the DZ \dQuote{C} factor
from 1 (the default for modeling family-level effects shared 100% by twins in a pair),
to .25 to model dominance effects.

\strong{Matrices and Labels in CP model}
A good way to see which matrices are used in umxCP is to run an example model and plot it.

The diagonals of matrices as, cs, and es contain the path loadings specific to each variable. So labels relevant to modifying these are of the form "as_r1c1", "as_r2c2" etc.
All the shared matrices are in the model "top". So to see the \code{as} values, you can say:

\code{m1$top#as$values}

The common-pathway loadings on the factors are in matrices a_cp, c_cp, e_cp.

The common factors themselves are in the matrix cp_loadings (an nVar * 1 matrix)

Less commonly-modified matrices are the mean matrix \code{expMean}. This has 1 row, and the columns are laid out for each variable for twin 1, followed by each variable for twin 2.
So, in a model where the means for twin 1 and twin 2 had been equated (set = to T1), you could make them independent again with this script:

\code{m1$top$expMean$labels[1,4:6] = c("expMean_r1c4", "expMean_r1c5", "expMean_r1c6")}
}
\examples{
\dontrun{
require(umx)
data(GFF)
mzData <- subset(GFF, zyg_2grp == "MZ")
dzData <- subset(GFF, zyg_2grp == "DZ")
selDVs = c("gff","fc","qol","hap","sat","AD") # These will be expanded into "gff_T1" "gff_T2" etc.
m1 = umxCPold(selDVs = selDVs, sep = "_T", nFac = 3, dzData = dzData, mzData = mzData)
umxSummary(m1)
umxParameters(m1, patt = "^c")
m2 = umxModify(m1, regex = "(cs_.*$)|(c_cp_)", name = "dropC")
umxSummaryCP(m2, comparison = m1, file = NA)
umxCompare(m1, m2)
}
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link{umxACE}()} for more examples of twin modeling, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.
}

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEv}},
  \code{\link{umxACE}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxEbiv}},
  \code{\link{umxGxE}}, \code{\link{umxIPnew}},
  \code{\link{umxIP}}, \code{\link{umxSexLim}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxEbiv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
\concept{Twin Modeling Functions}
