% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_cor}
\alias{umx_cor}
\title{Report correlations and their p-values}
\usage{
umx_cor(X, df = nrow(X) - 2, use = c("pairwise.complete.obs",
  "complete.obs", "everything", "all.obs", "na.or.complete"), digits = 2,
  type = c("r and p-value", "smart"))
}
\arguments{
\item{X}{a matrix or dataframe}

\item{df}{the degrees of freedom for the test}

\item{use}{how to handle missing data (defaults to pairwise complete)}

\item{digits}{rounding of answers}

\item{type}{Unused argument for future directions}
}
\value{
- Matrix of correlations and p-values
}
\description{
For reporting correlations and their p-values in a compact table. Handles rounding, and skipping non-numeric columns.
}
\details{
To compute heterochoric correlations, see \code{\link{umxHetCor}}.

note: The Hmisc package has a more robust function called rcorr
}
\examples{
umx_cor(myFADataRaw[1:8,])
}
\references{
- \url{https://www.github.com/tbates/umx}
}
\seealso{
umxHetCor

Other Miscellaneous Stats Helpers: \code{\link{reliability}},
  \code{\link{umxCov2cor}}, \code{\link{umxHetCor}},
  \code{\link{umx_apply}}, \code{\link{umx_fun_mean_sd}},
  \code{\link{umx_means}}, \code{\link{umx_r_test}},
  \code{\link{umx_round}}, \code{\link{umx_var}},
  \code{\link{umx}}
}
\concept{Miscellaneous Stats Helpers}
