% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummarizeTwinData}
\alias{umxSummarizeTwinData}
\title{Summarize twin data}
\usage{
umxSummarizeTwinData(data = NULL, selVars = "wt", sep = "_T",
  zyg = "zygosity", MZ = NULL, DZ = NULL, MZFF = "MZFF",
  DZFF = "DZFF", MZMM = "MZMM", DZMM = "DZMM", DZOS = "DZOS",
  digits = 2, report = c("markdown", "html"))
}
\arguments{
\item{data}{The twin data.}

\item{selVars}{Collection of variables to report on, e.g. c("wt", "ht").}

\item{sep}{The separator string that will turn a variable name into a twin variable name, e.g. "_T" for wt_T1 and wt_T2.}

\item{zyg}{The zygosity variable in the dataset, e.g. "zygosity".}

\item{MZ}{Set level in zyg corresponding to MZ for two group case (defaults to using 5-group case).}

\item{DZ}{Set level in zyg corresponding to DZ for two group case (defaults to using 5-group case).}

\item{MZFF}{The level in zyg corresponding to MZ FF pairs: e.g., "MZFF".}

\item{DZFF}{The level in zyg corresponding to DZ FF pairs: e.g., "DZFF".}

\item{MZMM}{The level in zyg corresponding to MZ MM pairs: e.g., "MZMM".}

\item{DZMM}{The level in zyg corresponding to DZ MM pairs: e.g., "DZMM".}

\item{DZOS}{The level in zyg corresponding to DZ OS pairs: e.g., "DZOS".}

\item{digits}{Rounding precision of the report (default 2).}

\item{report}{What to return (default = 'markdown'). Use 'html' to open a web table.}
}
\value{
\itemize{
\item formatted table, e.g. in markdown.
}
}
\description{
Produce a summary of wide-format twin data, showing the number of individuals, the mean and SD for each trait, and the correlation for each twin-type.

Set MZ and DZ to summarize the two-group case.
}
\examples{
data(twinData)
umxSummarizeTwinData(twinData, sep = "", selVars = c("wt", "ht"))
MZs = c("MZMM", "MZFF"); DZs = c("DZFF","DZMM", "DZOS")
umxSummarizeTwinData(twinData, sep = "", selVars = c("wt", "ht"), MZ = MZs, DZ = DZs)
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=umxAPA]{umxAPA()}}
}

Other Twin Reporting Functions: \code{\link{umxPlotCP}()},
  \code{\link{umxReduceACE}()},
  \code{\link{umxReduceGxE}()}, \code{\link{umxReduce}()},
  \code{\link{umxSummaryACEcov}()},
  \code{\link{umxSummaryACEv}()},
  \code{\link{umxSummaryACE}()},
  \code{\link{umxSummaryCP}()},
  \code{\link{umxSummaryGxEbiv}()},
  \code{\link{umxSummaryGxE}()},
  \code{\link{umxSummaryIP}()},
  \code{\link{umxSummarySexLim}()},
  \code{\link{umxSummarySimplex}()}, \code{\link{umx}}
}
\concept{Twin Reporting Functions}
