% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umx_APA_pval}
\alias{umx_APA_pval}
\title{Round p-values according to APA guidelines}
\usage{
umx_APA_pval(p, min = 0.001, digits = 3, addComparison = NA)
}
\arguments{
\item{p}{The p-value to round}

\item{min}{Values below min will be reported as "< min"}

\item{digits}{Number of decimals to which to round (default = 3)}

\item{addComparison}{Whether to add '=' '<' etc. (NA adds when needed)}
}
\value{
\itemize{
\item p-value formatted in APA style
}
}
\description{
\code{umx_APA_pval} formats p-values, rounded in APA style. So you get '< .001' instead of .000000002 or 1.00E-09.

You probably would be better off using \code{\link[=umxAPA]{umxAPA()}}, which handles many more object types.

You set the precision with digits. Optionally, you can add '=' '<' etc. The default for addComparison (NA) adds these when needed.
}
\examples{
umx_APA_pval(.052347)
umx_APA_pval(1.23E-3)
umx_APA_pval(1.23E-4)
umx_APA_pval(c(1.23E-3, .5))
umx_APA_pval(c(1.23E-3, .5), addComparison = TRUE)
}
\seealso{
\itemize{
\item \code{\link[=umxAPA]{umxAPA()}}, \code{\link[=round]{round()}}
}

Other Reporting Functions: \code{\link{FishersMethod}()},
  \code{\link{loadings.MxModel}()},
  \code{\link{tmx_is.identified}()},
  \code{\link{tmx_show}()}, \code{\link{umxAPA}()},
  \code{\link{umxFactorScores}()},
  \code{\link{umxGetParameters}()},
  \code{\link{umxParameters}()}, \code{\link{umxReduce}()},
  \code{\link{umxWeightedAIC}()},
  \code{\link{umx_aggregate}()}, \code{\link{umx_names}()},
  \code{\link{umx_print}()}, \code{\link{umx_time}()},
  \code{\link{umx}}
}
\concept{Reporting Functions}
