% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{xmu_cell_is_on}
\alias{xmu_cell_is_on}
\title{Return whether a cell is in a set location of a matrix}
\usage{
xmu_cell_is_on(r, c, where = c("diag", "lower", "lower_inc", "upper",
  "upper_inc", "any", "left"), mat = NULL)
}
\arguments{
\item{r}{which row the cell is on.}

\item{c}{which column the cell is in.}

\item{where}{the location (any, diag, lower or upper (or _inc) or left).}

\item{mat}{(optionally) provide matrix to check dimensions against r and c.}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Helper to determine is a cell is in a set location of a matrix or not.
Left is useful for, e.g. twin means matrices.
}
\examples{
xmu_cell_is_on(r = 3, c = 3, "lower")
xmu_cell_is_on(r = 3, c = 3, "lower_inc")
xmu_cell_is_on(r = 3, c = 3, "upper")
xmu_cell_is_on(r = 3, c = 3, "upper_inc")
xmu_cell_is_on(r = 3, c = 3, "diag")
xmu_cell_is_on(r = 2, c = 3, "diag")
xmu_cell_is_on(r = 3, c = 3, "any")
a_cp = umxMatrix("a_cp", "Lower", 3, 3, free = TRUE, values = 1:6)
xmu_cell_is_on(r = 3, c = 3, "left", mat = a_cp)
\dontrun{
# test stopping
xmu_cell_is_on(r=4,c = 3, "any", mat = a_cp)
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umxLabel]{umxLabel()}}
}

Other Miscellaneous Utility Functions: \code{\link{install.OpenMx}()},
  \code{\link{qm}()}, \code{\link{umxBrownie}()},
  \code{\link{umxFactor}()}, \code{\link{umxLav2RAM}()},
  \code{\link{umxVersion}()},
  \code{\link{umx_array_shift}()},
  \code{\link{umx_cont_2_quantiles}()},
  \code{\link{umx_find_object}()},
  \code{\link{umx_make}()}, \code{\link{umx_msg}()},
  \code{\link{umx_open_CRAN_page}()},
  \code{\link{umx_pad}()}, \code{\link{umx_pb_note}()},
  \code{\link{umx_print}()},
  \code{\link{umx_score_scale}()}, \code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
