% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{RMSEA.summary.mxmodel}
\alias{RMSEA.summary.mxmodel}
\title{RMSEA function for MxModels}
\usage{
\method{RMSEA}{summary.mxmodel}(x, ci.lower = 0.05, ci.upper = 0.95, digits = 3)
}
\arguments{
\item{x}{an \code{\link[=mxModel]{mxModel()}} summary from which to get RMSEA}

\item{ci.lower}{the lower CI to compute}

\item{ci.upper}{the upper CI to compute}

\item{digits}{digits to show (defaults to 3)}
}
\value{
\itemize{
\item object containing the RMSEA and lower and upper bounds
}
}
\description{
Compute the confidence interval on RMSEA and print it out.
\emph{note}: If your goal is to extract the RMSEA from a model, use \code{RMSEA(m1)$RMSEA}
}
\examples{
\dontrun{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)

m1 = umxRAM("One Factor", data = demoOneFactor[1:100,], type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1.0)
)
tmp = summary(m1)
RMSEA(tmp)
}
}
\references{
\itemize{
\item \url{https://github.com/simsem/semTools/wiki/Functions}, \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Reporting functions: 
\code{\link{RMSEA.MxModel}()},
\code{\link{RMSEA}()},
\code{\link{extractAIC.MxModel}()},
\code{\link{loadings}()},
\code{\link{residuals.MxModel}()},
\code{\link{tmx_show.MxMatrix}()},
\code{\link{tmx_show}()},
\code{\link{umxCI_boot}()},
\code{\link{umxCI}()},
\code{\link{umxConfint}()},
\code{\link{umxExpCov}()},
\code{\link{umxExpMeans}()},
\code{\link{umxFitIndices}()},
\code{\link{umxRotate}()}
}
\concept{Reporting functions}
