% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NotreDame.R
\docType{data}
\name{notredame_2}
\alias{notredame_2}
\title{Secondary colors of the University of Notre Dame, USA}
\format{
An object of class \code{character} of length 11.
}
\source{
Color definitions are based on 
\href{https://onmessage.nd.edu/university-branding/colors/}{ND's website}.
}
\usage{
notredame_2
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{notredame_2} provides the 11 secondary colors
of the \href{https://www.nd.edu}{University of Notre Dame}, USA.
}
\details{
The 11 secondary colors are 
\code{"brand_blue_light"} (defined as HEX #143865),
\code{"brand_blue_bright"} (defined as HEX #1c4f8f),
\code{"brand_gold_dark"} (defined as HEX #8c7535),
\code{"brand_gold_light"} (defined as HEX #d39f10), 
\code{"sky_blue"} (defined as HEX #e1e8f2), 
\code{"sky_blue_dark"} (defined as HEX #c1cddd), 
\code{"sky_blue_light"} (defined as HEX #edf2f9), 
\code{"warm_white"} (defined as HEX #f8f4ec), 
\code{"warm_white_dark"} (defined as HEX #efe9d9), 
\code{"brand_green"} (defined as HEX #0a843d), and 
\code{"brand_green_light"} (defined as HEX #b3dac5).

\code{notredame_2} uses the HEX color definitions.
}
\examples{
notredame_2
unikn::seecol(notredame_2, main = "University of Notre Dame") # view color palette

}
\seealso{
\code{\link{notredame_1}} for the primary colors of Notre Dame;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes.: 
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{limerick_2}},
\code{\link{trinity_2}},
\code{\link{uci_2}},
\code{\link{uflorida_2}},
\code{\link{vanderbilt_2}}
}
\author{
\strong{unicol}, 2320-07-16.
}
\concept{university color palettes.}
\keyword{datasets}
