% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/efficiency.R
\docType{methods}
\name{efficiency,USL-method}
\alias{efficiency}
\alias{efficiency,USL-method}
\title{Efficiency of the system}
\usage{
\S4method{efficiency}{USL}(object)
}
\arguments{
\item{object}{A USL object.}
}
\value{
A vector of numeric values.
}
\description{
The efficiency of a system expressed in terms of the deviation from
linear scalability.
}
\details{
The function returns a vector which contains the deviation from linearity
for every measurement of the model input.  A value of \code{1} indicates
linear scalability while values less than \code{1} correspond to the
fraction of the measurement compared to linear scalability.
}
\examples{
require(usl)

data(raytracer)

## Show the efficiency
efficiency(usl(throughput ~ processors, raytracer))
}
\references{
Neil J. Gunther. Guerrilla Capacity Planning: A Tactical
  Approach to Planning for Highly Scalable Applications and Services.
  Springer, Heidelberg, Germany, 1st edition, 2007.
}
\seealso{
\code{\link{usl}}
}

