% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-us-map.R
\name{create_us_map}
\alias{create_us_map}
\alias{ea_crs}
\alias{transform2D}
\alias{transform_alaska}
\alias{transform_hawaii}
\alias{compute_centroids}
\alias{alaska_bbox}
\alias{hawaii_bbox}
\title{Internal map creation tools}
\usage{
create_us_map(
  type = c("states", "counties"),
  input_file,
  output_dir,
  output_file
)

ea_crs()

transform2D(angle = 0, scale = 1)

transform_alaska(alaska)

transform_hawaii(hawaii)

compute_centroids(polygons, iterations = 3, initial_width_step = 10)

alaska_bbox()

hawaii_bbox()
}
\description{
\code{create_us_map()} creates the modified shapefiles used by the
\link[usmap]{usmap} package.

\code{ea_crs()} returns the US National Atlas Equal Area coordinate reference system
(CRS) used by this package and \code{usmap}.

\code{transform2D()} computes a two dimensional affine transformation matrix
for the provided rotation angle and scale factor.

\code{transform_alaska()} applies the appropriate transform for the Alaska polygons.

\code{transform_hawaii()} applies the appropriate transform for the Hawaii polygons.

\code{compute_centroids()} computes the modified centroids for each state or
county polygon using a center-of-mass technique on the largest polygon in
the region.

\code{alaska_bbox()} returns the bounding box of Alaska pre-transformation.

\code{hawaii_bbox()} returns the bounding box of Hawaii pre-transformation.
}
\note{
Using these functions externally is not recommended since they make certain
undocumented assumptions that may not work with all inputs.

It is strongly recommend that the \link[usmap]{usmap} package is used
directly.

In some cases where the raw data is required, the \link{us_map} and
\link{centroid_labels} functions located in this package can be used instead.
}
\references{
{
Gert (2017). “How to calculate
polygon centroids in R (for
non-contiguous shapes).”
\url{https://gis.stackexchange.com/a/265475}.

Rudis B (2014). “Moving The Earth
(well, Alaska & Hawaii) With R.”
\url{https://rud.is/b/2014/11/16/moving-the-earth-well-alaska-hawaii-with-r/}.
}
}
\keyword{internal}
