% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queue.R
\name{queue}
\alias{queue}
\alias{print.queue}
\alias{plot.queue}
\alias{summary.queue}
\alias{print.summary.queue}
\alias{plot.summary.queue}
\title{Generate queuing information from arrival and use times}
\usage{
queue(
  n,
  arrive,
  use.full,
  wait.max = NULL,
  revive = 0,
  close.arrive = Inf,
  close.service = Inf,
  close.full = Inf
)

\method{print}{queue}(x, ...)

\method{plot}{queue}(
  x,
  print = TRUE,
  gap = NULL,
  line.width = 2,
  line.colors = NULL,
  line.colours = line.colors,
  ...
)

\method{summary}{queue}(object, probs = NULL, probs.decimal.places = 2, ...)

\method{print}{summary.queue}(x, ...)

\method{plot}{summary.queue}(
  x,
  print = TRUE,
  count = FALSE,
  bar.colors = NULL,
  bar.colours = bar.colors,
  ...
)
}
\arguments{
\item{n}{Number of service facilities at the amenity (positive integer)}

\item{arrive}{Vector of arrival-times for the users (non-negative numeric values)}

\item{use.full}{Vector of (intended) use-times for the users (non-negative numeric values)}

\item{wait.max}{Vector of maximum-waiting-times for the users (non-negative numeric values)}

\item{revive}{Revival-time for service facilities}

\item{close.arrive}{Closure-time for new arrivals (no new arrivals allowed)}

\item{close.service}{Closure-time for new services (no new services allowed)}

\item{close.full}{Closure-time for all services (all existing services are terminated)}

\item{x, object}{a \code{queue} object}

\item{...}{further arguments passed to or from other methods.}

\item{print, gap, line.width, line.colors, line.colours}{plotting paramaters}

\item{probs}{summary quantiles to be included in output.}

\item{probs.decimal.places}{rounds the output to specified number of decimal places.}

\item{count}{absolute or relative frequencies}

\item{bar.colors, bar.colours}{plotting parameters}
}
\value{
If all inputs are correctly specified then the function will return a list of class \code{queue}
containing queuing information for the users and service facilities
}
\description{
\code{queue} returns queuing information for users and service facilities.
}
\details{
This function computes takes inputs giving the arrival times and (intended) use times for a set of users at
an amenity, plus the number of service facilities at the amenity.  The function computes full information on
the use of the facilities by the users, including their waiting time, actual use time, leaving time, and the
facility that was used by each user.

In addition to the required inputs, the function also accepts inputs for a maximum-waiting time for each user;
if the user waits up to this time then the user will leave without service.  The user can also impose closure
times on new arrivals, new services, or termination of services.

**Note:** Service facilities are assumed to be allocated to users on a "first-come, first-served" basis; in the
event that more than one service facility is available for a user then the user is allocated to facilities
first-to-last based on the facility number (i.e., the allocation favours the earlier facilities and it is
not exchangeable with respect to the facility number).
}
\examples{
q <- queue(2, 4:6, 7:9)
summary(q)
plot(q)
plot(summary(q))
}
