% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pip.R
\name{plot.pip}
\alias{plot.pip}
\title{Plot \code{pip} Objects}
\usage{
\method{plot}{pip}(x, fill = "black", width = 0.5, ...)
}
\arguments{
\item{x}{An object of class \code{pip}.}

\item{fill}{Character string. Which color for the bars
(defaults to \code{black})?}

\item{width}{Numeric. The width for the bars (defaults to \code{0.5}).}

\item{...}{Currently ignored}
}
\value{
A \code{ggplot} object.
}
\description{
Bar plot for the posterior inclusion probabilities, which corresponds to
             the probability that each group differs from the average within-group
             variance.
}
\examples{
\donttest{

# congruent trials
congruent <- subset(flanker, cond == 0)

# subset 25 from each group
dat <- congruent[unlist(tapply(1:nrow(congruent),
                            congruent$id,
                            head, 25)), ]
fit <- vicc(
  y  = dat$rt,
  group = dat$id,
  iter = 500,
  burnin = 10,
  type =  "pick_group"
)

pips <- pip(fit)

plot(pips)

}
}
