% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagnostics}
\alias{diagnostics}
\title{Run diagnostics}
\usage{
diagnostics(obj)
}
\arguments{
\item{obj}{An object of class \code{vaccine_est} returned by
\code{\link{est_ce}}}
}
\value{
A combined plot of model diagnostics
}
\description{
Run a set of diagnostic plots. Note that for this function to
    work, \code{\link{est_ce}} must be run with \code{return_extras=T}.
}
\examples{
data(hvtn505)
dat <- load_data(time="HIVwk28preunblfu", event="HIVwk28preunbl", vacc="trt",
                 marker="IgG_V2", covariates=c("age","BMI","bhvrisk"),
                 weights="wt", ph2="casecontrol", data=hvtn505)
\donttest{
ests_np <- est_ce(dat=dat, type="NP", t_0=578, return_extras=TRUE)
diagnostics(ests_np)
}
}
