% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_med.R
\name{est_med}
\alias{est_med}
\title{Estimate mediation effects}
\usage{
est_med(
  dat,
  type = "NP",
  t_0,
  nde = TRUE,
  nie = TRUE,
  pm = TRUE,
  scale = "RR",
  params_np = params_med_np()
)
}
\arguments{
\item{dat}{A data object returned by load_data}

\item{type}{One of c("NP", "Cox"). This specifies whether to estimate the
effects using a marginalized Cox proportional hazards model or using a
nonparametric estimator.}

\item{t_0}{Time point of interest}

\item{nde}{Boolean. If TRUE, the natural direct effect is computed and
returned.}

\item{nie}{Boolean. If TRUE, the natural indirect effect is computed and
returned.}

\item{pm}{Boolean. If TRUE, the proportion mediated is computed and returned.}

\item{scale}{One of c("RR", "VE"). This determines whether NDE and NIE
estimates and CIs are computed on the risk ratio (RR) scale or the
vaccine efficacy (VE) scale. The latter equals one minus the former.}

\item{params_np}{A list of options returned by \code{\link{params_med_np}}
that are relevant if type="NP".}
}
\value{
A dataframe containing the following columns: \itemize{
    \item{\code{effect}: one of c("NDE", "NIE", "PM")}
    \item{\code{est}: point estimate}
    \item{\code{se}: standard error of point estimate}
    \item{\code{ci_lower}: a confidence interval lower limit}
    \item{\code{ci_upper}: a confidence interval upper limit}
}
}
\description{
Estimate mediation effects, including the natural direct effect
    (NDE), the natural indirect effect (NIE), and the proportion mediated
    (PM). See references for definitions of these objects.
}
\examples{
data(hvtn505)
dat <- load_data(time="HIVwk28preunblfu", event="HIVwk28preunbl", vacc="trt",
                 marker="IgG_V2", covariates=c("age","BMI","bhvrisk"),
                 weights="wt", ph2="casecontrol", data=hvtn505)
\donttest{
ests_np <- est_med(dat=dat, type="NP", t_0=578)
}
}
\references{
Fay MP and Follmann DA (2023). Mediation Analyses for the Effect
    of Antibodies in Vaccination <doi:10.48550/arXiv.2208.06465>
}
