% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_warnings.R
\name{capture_warnings}
\alias{capture_warnings}
\title{Capture Warnings}
\usage{
capture_warnings(expr, warn_env = new.env())
}
\arguments{
\item{expr}{An expression to evaluate.}

\item{warn_env}{An optional environment to store the warnings.
If not provided, a new environment is created.}
}
\value{
A list containing two elements:
\item{result}{The result of evaluating the expression.}
\item{warnings}{A character vector of the warnings generated during
the evaluation of the expression.}
}
\description{
This function captures the warnings generated by an
expression without printing them to the console. It returns both the
result of the expression and the captured warnings. This is useful for
avoiding warnings appearing during routines, such as an iterative process.
To suppress or "muffle" a warning, it uses invokeRestart("muffleWarning").
The \code{new.env()} function creates a new environment that is isolated from
other environments. This allows the function to store and modify data
(in this case, warnings) without affecting the global environment or
any other environment in the R session.
}
\keyword{internal}
