% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_vaccineff_data.R
\name{make_vaccineff_data}
\alias{make_vaccineff_data}
\title{Construct \code{vaccineff_data} Object}
\usage{
make_vaccineff_data(
  data_set,
  outcome_date_col,
  censoring_date_col = NULL,
  vacc_date_col,
  vacc_name_col = NULL,
  vaccinated_status = "v",
  unvaccinated_status = "u",
  immunization_delay = 0,
  end_cohort,
  match = FALSE,
  exact = NULL,
  nearest = NULL,
  take_first = FALSE,
  t0_follow_up = NULL
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{outcome_date_col}{Name of the column that contains the outcome dates.}

\item{censoring_date_col}{Name of the column that contains the censoring
date. NULL by default.}

\item{vacc_date_col}{Name of the column(s) that contain the vaccine dates.}

\item{vacc_name_col}{Name of the column(s) that contain custom vaccine
names for the vaccines (e.g. brand name, type of vaccine). If provided,
must be of the same length as \code{vacc_date_col}.}

\item{vaccinated_status}{Status assigned to the vaccinated population.
Default is \code{v}.}

\item{unvaccinated_status}{Status assigned to the unvaccinated population.
Default is \code{u}.}

\item{immunization_delay}{Characteristic time in days before the patient
is considered immune. Default is 0.}

\item{end_cohort}{End date of the study.}

\item{match}{\code{TRUE}: cohort matching is performed. Default is \code{FALSE}}

\item{exact}{Name(s) of column(s) for \code{exact} matching. Default is \code{NULL}.}

\item{nearest}{Named vector with name(s) of column(s) for \code{nearest} matching
and caliper(s) for each variable (e.g., \code{nearest = c("characteristic1" = n1, "characteristic2" = n2)}, where \code{n1} and \code{n2} are the calipers). Default is
\code{NULL}.}

\item{take_first}{\code{FALSE}: takes the latest vaccine date. \code{TRUE}: takes the
earliest vaccine date.}

\item{t0_follow_up}{Column with the initial dates of the follow-up period.
This column is only used if \code{match = FALSE}. If not provided, the follow-up
period starts at \code{start_cohort}. Default is NULL.}
}
\value{
An S3 object of class \code{vaccineff_data} with all the information and
characteristics of the study. \code{data.frames} are converted into an object of
class \code{linelist} to easily handle with the data.
}
\description{
This function constructs an S3 object of the class
\code{vaccineff_data} that contains all the relevant information for the study.
to estimate the effectiveness.
}
\examples{
\donttest{
# Load example data
data("cohortdata")

# Create `vaccineff_data`
vaccineff_data <- make_vaccineff_data(data_set = cohortdata,
  outcome_date_col = "death_date",
  censoring_date_col = "death_other_causes",
  vacc_date_col = "vaccine_date_2",
  vaccinated_status = "v",
  unvaccinated_status = "u",
  immunization_delay = 15,
  end_cohort = as.Date("2021-12-31"),
  match = TRUE,
  exact = c("age", "sex"),
  nearest = NULL
)

# Print summary of data
summary(vaccineff_data)

# Plot vaccine coverage
plot(vaccineff_data)
}
}
