% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkers.R
\name{type-checkers}
\alias{type-checkers}
\title{Type checkers}
\arguments{
\item{\dots}{Check items, i.e., formulae that are one-sided or have a string
as left-hand side (see \emph{Check Formulae of Local Scope} in the
documentation page \link{firmly}). These are the expressions to check.}
}
\value{
Check formula of local scope.
}
\description{
These functions make check formulae of local scope based on the
correspondingly named type predicate from the
\href{https://cran.r-project.org/package=purrr}{\pkg{purrr}} package, with
the exception that \code{vld_closure} corresponds to the (inaptly named)
\pkg{purrr} predicate \code{\link[purrr]{is_function}}. For example,
\code{vld_atomic} creates check formulae (of local scope) for the \pkg{purrr}
predicate function \code{\link[purrr]{is_atomic}}.
}
\details{
Each function \code{vld_*} is a function of class
  \code{"check_maker"}, generated by \code{\link{localize}}.
}
\examples{
\dontrun{

f <- function(x, y) "Pass"

# Impose a check on x: ensure it's of type "logical"
f_firm <- firmly(f, vld_logical(~x))
f_firm(TRUE, 0)  # [1] "Pass"
f_firm(1, 0)     # Error: "Not logical: x"

# Use a custom error message
f_firm <- firmly(f, vld_logical("x should be a logical vector" ~ x))
f_firm(1, 0)     # Error: "x should be a logical vector"

# To impose the same check on all arguments, apply globalize()
f_firmer <- firmly(f, globalize(vld_logical))
f_firmer(TRUE, FALSE)  # [1] "Pass"
f_firmer(TRUE, 0)      # Error: "Not logical: `y`"
f_firmer(1, 0)         # Errors: "Not logical: `x`", "Not logical: `y`"
}
}
\alias{vld_atomic}
\alias{vld_character}
\alias{vld_closure}
\alias{vld_double}
\alias{vld_integer}
\alias{vld_list}
\alias{vld_logical}
\alias{vld_null}
\alias{vld_vector}
\usage{
vld_atomic(...)

vld_character(...)

vld_closure(...)

vld_double(...)

vld_integer(...)

vld_list(...)

vld_logical(...)

vld_null(...)

vld_vector(...)
}
\seealso{
Corresponding predicates: Type predicates (\href{https://cran.r-project.org/package=purrr}{\pkg{purrr}})

\code{\link{globalize}} recovers the underlying check formula of global scope.

The notions of \dQuote{scope} and \dQuote{check item} are explained in the \emph{Check Formulae} section of \link{firmly}.

\code{\link{vld_numeric}} does not check according to type, and is not based on \code{purrr::is_numeric} (deprecated since 0.2.2.9000); rather, it is based on the predicate \code{\link[base]{is.numeric}}, which checks whether an object is \dQuote{numerical} in the sense of \code{\link[base]{mode}} instead of \code{\link[base]{typeof}}. In particular, factors are not regarded as \dQuote{numerical}.

Other checkers: \link{misc-checkers}, \link{bare-type-checkers}, \link{scalar-type-checkers}
}
