% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qq.R
\name{qq}
\alias{qq}
\title{Simplified Normal (Q-Q) Plot}
\usage{
qq(df, var1, by1, by2)
}
\arguments{
\item{df}{data frame to read in.}

\item{var1}{the dependent/outcome variable, \eqn{Y}. The variable of interest that should be plotted.}

\item{by1}{the main independent/predictor variable, \eqn{X_1}. A grouping variable by which the Q-Q plot for \code{var1} should be parsed.}

\item{by2}{a potential second independent/predictor variable, \eqn{X_2}. A second grouping variable by which the Q-Q plot for \code{var1} (already parsed by \code{by1}) should be parsed.}
}
\value{
This function returns the quantile-quantile plot for \code{var1} in data frame \code{df}. Can be split to return a quantile-quantile plot for \code{var1} in data frame \code{df}, broken out by \code{var2}.
}
\description{
This function plots a Q-Q/Quantile-Quantile plot (qq) on a given data frame, and uses simplified calls within the function to parse the Q-Q plot by up to 2 variables.
}
\examples{
data <- mtcars

qq(data,mpg,cyl)
}
