"normality" <-
function(x){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'var()'.\n")
  }
  obj.name <- deparse(substitute(x))
  K <- x$K
  obs <- x$obs
  resid <- x$resid
  resids <- scale(resid, scale=FALSE)
  ## Jarque Bera Test (univariate)
  jbu.resids <- apply(resids, 2, function(x) .jb.uni(x, obs = obs))
  for(i in 1 : K)
    jbu.resids[[i]][5] <- paste("Residual of", colnames(resids)[i], "equation")
  ## Jarque Bera Test (multivariate)
  jbm.resids <- .jb.multi(resids, obs = obs, K = K, obj.name = obj.name)
  result <- list(resid = resid, jb.uni = jbu.resids, jb.mul = jbm.resids)
  class(result) <- "varcheck"
  return(result)
}
