"arch" <-
function(x, lags.single = 16, lags.multi = 5){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'var()'.\n")
  }
  obj.name <- deparse(substitute(x))
  lags.single <- abs(as.integer(lags.single))
  lags.multi <- abs(as.integer(lags.multi)) 
  K <- x$K
  obs <- x$obs
  resid <- x$resid
  resids <- scale(resid)
  ## ARCH test (univariate)
  archs.resids <- apply(resids, 2, function(x) .arch.uni(x, lags.single = lags.single))
  for(i in 1 : K)
    archs.resids[[i]][5] <- paste("Residual of", colnames(resids)[i], "equation")
  ## ARCH test (multivariate)
  archm.resids <- .arch.multi(resids, lags.multi = lags.multi, K = K, obs = obs, obj.name = obj.name)
  result <- list(resid=resid, arch.uni=archs.resids, arch.mul=archm.resids)
  class(result) <- "varcheck"
  return(result)
}
