\name{SVAR}

\alias{SVAR}

\alias{print.svarest}

\title{Estimation of a SVAR}

\encoding{latin1}

\description{
  Estimates an SVAR (either \sQuote{A-model}, \sQuote{B-model} or
  \sQuote{AB-model}) by numerically minimising the negative
  log-likelihood using \command{optim()}.  
}
  
\usage{
SVAR(x, Amat = NULL, Bmat = NULL, start = NULL, ...)
}

\arguments{
  \item{x}{Object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}.}
  \item{Amat}{Matrix with dimension \eqn{(K \times K)} for A- or AB-model.}
  \item{Bmat}{Matrix with dimension \eqn{(K \times K)} for B- or AB-model.}
  \item{start}{Vector with starting values for the parameters to be
    optimised.}  
  \item{\dots}{Arguments that arr passed to \command{optim()}.}
}

\details{
  Consider the following structural form of a k-dimensional vector
  autoregressive model: 

  \deqn{
    A \bold{y}_t = A_1^*\bold{y}_{t-1} + \ldots + A_p^*\bold{y}_{t-p} +
    C^*D_t + B\bold{\varepsilon}_t
  }

  The coefficient matrices \eqn{(A_1^* | \ldots | A_p^* | C^*)} might
  now differ from the ones of a VAR (see \code{?VAR}). One can now
  impose restrictions on \sQuote{\code{A}} and/or \sQuote{\code{B}},
  resulting in an \sQuote{A-model} or \sQuote{B-model} or if the
  restrictions are placed on both matrices, an \sQuote{AB-model}. In case
  of a SVAR \sQuote{A-model}, \eqn{B = I_K} and conversely for a
  SVAR \sQuote{B-model}. Please note that for either an \sQuote{A-model} or
  \sQuote{B-model}, \eqn{K(K-1)/2} restrictions have to be imposed, such
  that the models' coefficients are identified. For an \sQuote{AB-model}
  the number of restrictions amounts to: \eqn{K^2 + K(K-1)/2}. The
  reduced form residuals can be obtained from the above equation
  \emph{via} the relation: \eqn{\bold{u}_t =
    A^{-1}B\bold{\varepsilon}_t}, with variance-covariance matrix
  \eqn{\Sigma_U = A^{-1}BB'A^{-1'}}.     

  
  Hence, for an \sQuote{A-model} a \eqn{(K \times K)} matrix has to be
  provided for the functional argument \sQuote{\code{Amat}} and the
  functional argument \sQuote{\code{Bmat}} must be set to
  \sQuote{\code{NULL}} (the default). Hereby, the to be estimated
  elements of \sQuote{\code{Amat}} have to be set as
  \sQuote{\code{NA}}. Conversely, for a \sQuote{B-model} a matrix object
  with dimension \eqn{(K \times K)} with elements set to
  \sQuote{\code{NA}} at the positions of the to be estimated parameters
  has to be provided and the functional argument \sQuote{\code{Amat}} is
  \sQuote{\code{NULL}} (the default). Finally, for an \sQuote{AB-model}
  both arguments, \sQuote{\code{Amat}} and \sQuote{\code{Bmat}}, have to
  be set as matrix objects containing desired restrictions and
  \sQuote{\code{NA}} values. The parameters are estimated by minimising the negative of the
  concentrated log-likelihood function:

  \deqn{
    \ln L_c(A, B) = - \frac{KT}{2}\ln(2\pi) + \frac{T}{2}\ln|A|^2 -
    \frac{T}{2}\ln|B|^2 - \frac{T}{2}tr(A'B'^{-1}B^{-1}A\tilde{\Sigma}_u) 
  }

  If \sQuote{\code{start}} is not set, then \code{0.1} is used as
  starting values for the unknown coefficients. If the function is
  called with \sQuote{\code{hessian = TRUE}}, the standard errors of the
  coefficients are returned as list elements \sQuote{\code{Ase}} and/or
  \sQuote{\code{Bse}}, where applicable.\cr Finally, in case of an
  overidentified SVAR, a likelihood ratio statistic is computed according to:

  \deqn{
    LR = T(\ln\det(\tilde{\Sigma}_u^r) - \ln\det(\tilde{\Sigma}_u))
    \quad , 
  }
  with \eqn{\tilde{\Sigma}_u^r} being the restricted variance-covariance
  matrix and \eqn{\tilde{\Sigma}_u} being the variance covariance matrix
  of the reduced form residuals. The test statistic is distributed as
  \eqn{\chi^2(nr - 2K^2 - \frac{1}{2}K(K + 1))}, where \eqn{nr} is equal
  to the number of restrictions.  
}

\value{
  A list of class \sQuote{\code{svarest}} with the following elements is
  returned:\cr
  
  \item{A}{If A- or AB-model, the matrix of estimated coeffiecients.}
  \item{Ase}{If \sQuote{\code{hessian = TRUE}}, the standard errors of
    \sQuote{\code{A}}, otherwise a null-matrix is returned.}
  \item{B}{If A- or AB-model, the matrix of estimated coeffiecients.}
  \item{Bse}{If \sQuote{\code{hessian = TRUE}}, the standard errors of
    \sQuote{\code{B}}, otherwise a null-matrix is returned.}
  \item{LRIM}{For Blanchard-Quah estimation \code{LRIM} is the estimated
    long-run impact matrix; for all other SVAR models \code{LRIM} is
    \code{NULL}.}  
  \item{Sigma.U}{The variance-covariance matrix of the reduced form
    residuals times 100, \emph{i.e.}, \eqn{\Sigma_U = A^{-1}BB'A^{-1'}
      \times 100}.}
  \item{LR}{Object of class \sQuote{code{htest}}, holding the Likelihood
  ratio overidentification test.}
  \item{opt}{List object returned by \command{optim()}.}
  \item{start}{Vector of starting values.}
  \item{type}{SVAR-type, character, either \sQuote{A-model},
    \sQuote{B-model} or \sQuote{AB-model}.}
  \item{var}{The \sQuote{\code{varest}} object \sQuote{\code{x}}.} 
  \item{call}{The \code{call} to \command{SVAR()}.}
}

\author{Bernhard Pfaff}

\references{
  Amisano, G. and C. Giannini (1997), \emph{Topics in Structural VAR
    Econometrics}, 2nd edition, Springer, Berlin.

  Breitung, J., R. Brggemann and H. Ltkepohl (2004), Structural vector
  autoregressive modeling and impulse responses, in H. Ltkepohl and
  M. Krtzig (editors), \emph{Applied Time Series Econometrics},
  Cambridge University Press, Cambridge.
  
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.
}

\seealso{
  \code{\link{VAR}}, \code{\link{SVAR2}}, \code{\link{SVEC}}
}

\examples{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
amat <- diag(4)
diag(amat) <- NA
amat[2, 1] <- NA
amat[4, 1] <- NA
SVAR(var.2c, Amat = amat, Bmat = NULL, hessian = TRUE, method="BFGS")
}

\keyword{regression}
\concept{SVAR}
\concept{Structural VAR}
\concept{Structural Vector Autoregressive}
\concept{A-model}
\concept{B-model}
\concept{AB-model}
