\name{residuals}

\alias{residuals}

\alias{residuals.varest}

\alias{residuals.vec2var}

\encoding{latin1}

\title{Residuals method for objects of class varest}

\description{
  Returns the residiuals of a VAR(p)-model for objects generated by
  \command{VAR()}. Thereby the residuals-method is applied to the list
  element \code{varresult}, which is itself a list of
  \code{lm}-objects. 
}

\usage{
\method{residuals}{varest}(object, ...)
\method{residuals}{vec2var}(object, ...)
}

\arguments{
  \item{object}{An object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}, or an object of class \sQuote{\code{vec2var}};
    generated by \command{vec2var()}} 
  \item{\dots}{Currently not used.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}
}

\examples{
\dontrun{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
resid(var.2c)
}
}

\keyword{regression}
