% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_radar}
\alias{v_radar}
\title{Create a Radar Chart}
\usage{
v_radar(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Radar Chart
}
\examples{

library(vchartr)

# Default radar chart
subset(electricity_mix, country == "Germany") \%>\%
  vchart() \%>\%
  v_radar(aes(source, generation))

# Without area
subset(electricity_mix, country == "Germany") \%>\%
  vchart() \%>\%
  v_radar(
    aes(source, generation),
    area = list(visible = FALSE)
  )


# Mutliple series
subset(electricity_mix, country \%in\% c("Germany", "Canada")) \%>\%
  vchart() \%>\%
  v_radar(aes(source, generation, color = country))



# Custom axes
subset(electricity_mix, country == "Germany") \%>\%
  vchart() \%>\%
  v_radar(aes(source, generation)) \%>\%
  v_scale_y_continuous(min = 0, max = 200)

subset(electricity_mix, country == "Germany") \%>\%
  vchart() \%>\%
  v_radar(aes(source, generation)) \%>\%
  v_scale_y_continuous(
    grid = list(smooth = FALSE),
    domainLine = list(visible = FALSE)
  ) \%>\%
  v_scale_x_discrete(
    label = list(space = 20),
    domainLine = list(visible = FALSE)
  )
}
