% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.agree}
\alias{meta.lc.agree}
\title{Confidence interval for a linear contrast of G-index coefficients}
\usage{
meta.lc.agree(alpha, f11, f12, f21, f22, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f11}{vector of frequencies in cell 1,1}

\item{f12}{vector of frequencies in cell 1,2}

\item{f21}{vector of frequencies in cell 2,1}

\item{f22}{vector of frequencies in cell 2,2}

\item{v}{vector of contrast coefficients}
}
\value{
Returns 1-row matrix with the estimate for the contrast. The matrix
has the following columns:
\itemize{
\item Estimate - estimate of linear contrast
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
linear contrast of G-index of agreement coefficients from two or more
studies. This function assumes that two raters each provide a dichotomous
rating for a sample of objects.
}
\examples{
f11 <- c(17, 28, 19)
f12 <- c(43, 56, 49)
f21 <- c(3, 5, 5)
f22 <- c(37, 54, 39)
v <- c(.5, .5, -1)
meta.lc.agree(.05, f11, f12, f21, f22, v)

# Should return:
#            Estimate        SE         LL        UL
# Contrast 0.07692783 0.1138407 -0.1461958 0.3000515


}
