% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_dist.R
\name{emis_dist}
\alias{emis_dist}
\title{Allocate emissions into spatial objects (street emis to grid)}
\usage{
emis_dist(gy, spobj, pro, osm, verbose = TRUE)
}
\arguments{
\item{gy}{Numeric; a unique total (top-down) emissions (grams)}

\item{spobj}{A spatial dataframe of class "sp" or "sf". When class is "sp"
it is transformed to "sf".}

\item{pro}{Matrix or data-frame profiles, for instance, pc_profile.}

\item{osm}{Numeric; vector of length 5, for instance, c(5, 3, 2, 1, 1).
The first element covers 'motorway' and 'motorway_link.
The second element covers 'trunk' and 'trunk_link'.
The third element covers 'primary' and 'primary_link'.
The fourth element covers 'secondary' and 'secondary_link'.
The fifth element covers 'tertiary' and 'tertiary_link'.}

\item{verbose}{Logical; to show more info.}
}
\description{
\code{\link{emis_dist}} allocates emissions proportionally to
each feature. "Spatial" objects are converter to "sf" objects. Currently,
'LINESTRING' or 'MULTILINESTRING' supported. The emissions are distributed
in each street.
}
\note{
When spobj is a 'Spatial' object (class of sp), they are converted
 into 'sf'.
}
\examples{
{
data(net)
data(pc_profile)
po <- 1000
t1 <- emis_dist(gy = po, spobj = net)
head(t1)
sum(t1$gy)
#t1 <- emis_dist(gy = po, spobj = net, osm = c(5, 3, 2, 1, 1) )
t1 <- emis_dist(gy = po, spobj = net, pro = pc_profile)
}
}
