% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_fitted_values}
\alias{check_fitted_values}
\title{Check pre-computed fitted values for call to vim, cv_vim, or sp_vim}
\usage{
check_fitted_values(
  Y = NULL,
  f1 = NULL,
  f2 = NULL,
  cross_fitted_f1 = NULL,
  cross_fitted_f2 = NULL,
  sample_splitting_folds = NULL,
  cross_fitting_folds = NULL,
  V = NULL,
  ss_V = NULL,
  cv = FALSE
)
}
\arguments{
\item{Y}{the outcome}

\item{f1}{estimator of the population-optimal prediction function
using all covariates}

\item{f2}{estimator of the population-optimal prediction function
using the reduced set of covariates}

\item{cross_fitted_f1}{cross-fitted estimator of the population-optimal
prediction function using all covariates}

\item{cross_fitted_f2}{cross-fitted estimator of the population-optimal
prediction function using the reduced set of covariates}

\item{sample_splitting_folds}{the folds for sample-splitting (used for
hypothesis testing)}

\item{cross_fitting_folds}{the folds for cross-fitting (used for point
estimates of variable importance in \code{cv_vim} and \code{sp_vim})}

\item{V}{the number of cross-fitting folds}

\item{ss_V}{the number of folds for CV (if sample_splitting is TRUE)}

\item{cv}{a logical flag indicating whether or not to use cross-fitting}
}
\value{
None. Called for the side effect of stopping the algorithm if
  any inputs are in an unexpected format.
}
\description{
Check pre-computed fitted values for call to vim, cv_vim, or sp_vim
}
\details{
Ensure that inputs to \code{vim}, \code{cv_vim}, and \code{sp_vim}
  follow the correct formats.
}
