% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi_shap.R
\name{vi_shap}
\alias{vi_shap}
\alias{vi_shap.default}
\title{SHAP-based variable importance}
\usage{
vi_shap(object, ...)

\method{vi_shap}{default}(object, feature_names = NULL, train = NULL, ...)
}
\arguments{
\item{object}{A fitted model object (e.g., a \code{"randomForest"} object).}

\item{...}{Additional optional arguments to be passed on to
\code{\link[fastshap]{explain}}.}

\item{feature_names}{Character string giving the names of the predictor
variables (i.e., features) of interest. If \code{NULL} (the default) then the
internal `get_feature_names()` function will be called to try and extract
them automatically. It is good practice to always specify this argument.}

\item{train}{A matrix-like R object (e.g., a data frame or matrix)
containing the training data. If \code{NULL} (the default) then the
internal `get_training_data()` function will be called to try and extract it
automatically. It is good practice to always specify this argument.}
}
\value{
A tidy data frame (i.e., a \code{"tibble"} object) with two columns,
\code{Variable} and \code{Importance}, containing the variable name and its
associated importance score, respectively.
}
\description{
Compute SHAP-based VI scores for the predictors in a model. See details
below.
}
\details{
This approach to computing VI scores is based on the mean absolute
value of the SHAP values for each feature; see, for example,
\url{https://github.com/slundberg/shap} and the references therein.

Strumbelj, E., and Kononenko, I. Explaining prediction models and individual
predictions with feature contributions. Knowledge and information systems
41.3 (2014): 647-665.
}
